IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CPJ_Cbtes_Lotes_Facturar]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CPJ_Cbtes_Lotes_Facturar] 
END
GO

CREATE PROCEDURE [dbo].[CPJ_Cbtes_Lotes_Facturar] @pJsonRecibido VARCHAR(8000)
AS 
SET NOCOUNT ON

/*
  VERSION  03/12/2021 
*/

DECLARE 	@pLote				VARCHAR(29),
			@pFecha				DATETIME,
			@pDescripcion		VARCHAR(50),
			@pId_Lote_Tipo		SMALLINT,
			@pFecha_Desde		DATETIME,
			@pFecha_Hasta		DATETIME,
			@pFecha_Rem_Desde	DATETIME,
			@pFecha_Rem_Hasta	DATETIME,
			@pFecha_QA       	DATETIME,
			@pFecha_Venc     	DATETIME,
			@pId_Tipo_Cont      INT,
			@pId_Usuario		INT,
			@pFiltrarTarjeta    Tinyint,
			@pFiltrarCliente    Tinyint,
			@pFiltrarCondPago   Tinyint,
			@pFiltrarTipoCbte   Tinyint,
			@pFiltrarCantCont   INT,
			@pRefacturar        TINYINT,
			@pIncl_Cbtes_Cero   Tinyint,
			@pFlagUsarTrans		TINYINT,
			@pModoDebug			TINYINT

SET @pLote				= ISNULL(CONVERT(VARCHAR(20), dbo.CF_JSON_VALUE(@pJsonRecibido,'Lote')), '')
SET @pFecha				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha')),GETDATE())
SET @pDescripcion		= ISNULL(CONVERT(VARCHAR(50), dbo.CF_JSON_VALUE(@pJsonRecibido,'Descripcion')), '')
SET @pId_Lote_Tipo		= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Lote_Tipo')), 0)
SET @pFecha_Desde		= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_Desde')),GETDATE())
SET @pFecha_Hasta		= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_Hasta')),GETDATE())
SET @pFecha_Rem_Desde	= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_Rem_Desde')),GETDATE())
SET @pFecha_Rem_Hasta	= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_Rem_Hasta')),GETDATE())
SET @pFecha_QA			= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_QA')),@pFecha_Desde)
SET @pFecha_Venc		= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_Venc')),@pFecha_Hasta)
SET @pId_Tipo_Cont		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Tipo_Cont')), 0)
SET @pId_Usuario		= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Usuario')), 0)
SET @pFiltrarTarjeta	= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FiltrarTarjeta')), 0)
SET @pFiltrarCliente	= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FiltrarCliente')), 0)
SET @pFiltrarCondPago	= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FiltrarCondPago')), 0)
SET @pFiltrarTipoCbte	= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FiltrarTipoCbte')), 0)
SET @pFiltrarCantCont	= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FiltrarCantCont')), 0)
SET @pRefacturar		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Refacturar')), 0)
SET @pIncl_Cbtes_Cero   = ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Incl_Cbtes_Cero')), 0)
SET @pFlagUsarTrans		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FlagUsarTrans')), 0)
SET @pModoDebug			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'ModoDebug')), 0)


/*Declaracion Variables Locales*/



DECLARE @Mensaje			VARCHAR(100)
		,@UltError			INT
		,@Segundos			INT



DECLARE @Sql		VARCHAR(MAX)
DECLARE @SqlSaldo	VARCHAR(MAX)
DECLARE @SqlSelect	VARCHAR(MAX)
DECLARE @SqlFrom	VARCHAR(MAX)
DECLARE @SqlWhere	VARCHAR(MAX)
DECLARE @SqlGroup	VARCHAR(MAX)

DECLARE @Id_Contrato INT
DECLARE @Id_Tiempo CHAR(3)
DECLARE @Flag_Agru_Cli_Ref TINYINT
DECLARE @Lote_en_proceso SMALLINT

DECLARE @pJson		VARCHAR(8000)

BEGIN TRY
      
      SET @Lote_en_proceso = ISNULL((SELECT COUNT(*) FROM Cbtes_Lotes WHERE Flag_enProceso = 1),0)
      IF(@Lote_en_proceso <>  0)  RAISERROR ('Existe actualmente otro Lote en proceso', 16,  1 ) 
      
	  DECLARE @Respuesta Table (
					ErrorNumber		INT,
					ErrorSeverity	INT,
					ErrorState		INT,
					ErrorProcedure  VARCHAR(1000),
					ErrorLine		INT,
					ErrorMessage	VARCHAR(1000)
					)

					
			    SET @pJson =	'{' +
							dbo.CF_Json_ParsearVariable('Id_Tipo_Lote', 1, 'INT') +  
							'}'
				INSERT INTO @Respuesta			
			    EXEC @UltError = CPJU_Tri_Parar @pJson

				SET @Mensaje = 'Error when calling CPJU_Tri_Parar ' + @pJson
	            IF @UltError <> 0 RAISERROR (@Mensaje, 16,  1 ) 					
					
		

	  SELECT @Flag_Agru_Cli_Ref = Flag_Agru_Cli_Ref FROM Contratos_Tipos WHERE Id_Tipo_Con = @pId_Tipo_Cont

	  CREATE TABLE #CONTRATOS_PROCESAR  (
				ID_CONTRATO INT,
				ID_TIEMPO CHAR(3) )
				

				
		SET @SqlSelect = 'SELECT O.ID_CONTRATO,ISNULL(O.ID_TIEMPO,'''')'

		IF @pFiltrarCantCont > 0 
		   SET @SqlSelect = 'SELECT TOP ' + CAST(@pFiltrarCantCont AS VARCHAR(10)) + '  O.ID_CONTRATO,ISNULL(O.ID_TIEMPO,'''')'

		SET @SqlFrom = 'FROM Contratos O,Clientes C'

		SET @SqlWhere = '  WHERE O.Id_Tipo_Con = ' + CAST(@pId_Tipo_Cont AS VARCHAR(10)) + '
							 AND O.Id_Cliente = C.Id_Cliente 
							 AND C.Activo = 1  AND O.Activo = 1
							 AND ( O.Fecha_Hasta >= '''+ CONVERT(VARCHAR(8),@pFecha_Desde+1,112) +'''
								 OR O.Fecha_Hasta IS NULL)
 							 AND O.Fecha_Desde < '''+ CONVERT(VARCHAR(8),@pFecha_Hasta+1,112) +'''
							 AND (O.Fecha_Cob_Hasta < '''+ CONVERT(VARCHAR(8),@pFecha_Hasta+1,112) +'''
								 OR O.Fecha_Cob_Hasta IS NULL)
							 AND (EXISTS (SELECT P.Id_Contrato FROM Contratos_Prod P WHERE P.Id_Contrato = O.Id_Contrato 
											   AND ISNULL(P.Flag_Facturable,0) <> 0 )
							     OR (EXISTS (SELECT 1 FROM Contratos_Tipos_Prod CT WHERE CT.Id_Tipo_Con = O.Id_Tipo_Con ))) '
											    		   

		 IF	@Flag_Agru_Cli_Ref <> 0 
    		SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND ISNULL(C.Id_Cliente_Ref,0) = 0'

		 IF	@pFiltrarCondPago <> 0 
    		SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND C.Id_Cond_Pago IN (SELECT CP.PTR FROM TagFile_ CP WHERE CP.USR = ' + CAST(@pId_Usuario AS VARCHAR(10)) + ' AND CP.TBL = 150)'
 
		 IF	@pFiltrarTipoCbte <> 0 
			SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND O.Id_tipo_cbte IN (SELECT CT.POS FROM TagFilePos_ CT WHERE CT.USR = ' + CAST(@pId_Usuario AS VARCHAR(10)) + ' AND CT.TBL = 120)'

		 IF	@pFiltrarCliente <> 0 
			SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND C.ID_CLIENTE IN (SELECT CP.PTR FROM TagFile_ CP WHERE CP.USR = ' + CAST(@pId_Usuario AS VARCHAR(10)) + ' AND CP.TBL = 400)'

		 IF	@pFiltrarTarjeta <> 0 
	 		SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND ( ISNULL(O.Id_Tarjeta,'') IN (SELECT TAR.POS FROM TagFilePos_ TAR WHERE TAR.USR = ' + CAST(@pId_Usuario AS VARCHAR(10)) + ' AND TAR.TBL = 210)
															OR ISNULL(C.Id_Tarjeta,'') IN (SELECT TAR.POS FROM TagFilePos_ TAR WHERE TAR.USR = ' + CAST(@pId_Usuario AS VARCHAR(10)) + ' AND TAR.TBL = 210) )'

		 IF @pRefacturar  <> 1 													
		    SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND O.ID_Contrato NOT IN (SELECT ID_Contrato  FROM Z_CONTRATOS_FACTURADOS P WHERE P.ID_Contrato = O.ID_Contrato)'
   

		SET  @SqlGroup	= 'ORDER BY O.ID_CLIENTE'

		SET @Sql = @SqlSelect +' '+ @SqlFrom + ' ' + @SqlWhere + ' ' + @SqlGroup
		IF @pModoDebug<> 0 PRINT @Sql

	
		INSERT INTO Cbtes_Lotes (Lote,Fecha,Descripcion,Id_Lote_Tipo,Flag_enProceso,Fecha_Inicio,Fecha_Desde,Fecha_Hasta,Observacion,Id_Tipo_Con)
			VALUES (@pLote,@pFecha,@pDescripcion,@pId_Lote_Tipo,1,GETDATE(),@pFecha_Desde,@pFecha_Hasta,@Sql,@pId_Tipo_Cont)
			

	    IF OBJECT_ID (N'Z_CONTRATOS_FACTURADOS', N'U') IS NOT NULL 
		BEGIN
			DROP TABLE Z_CONTRATOS_FACTURADOS
		END

 	    SELECT ISNULL(I.Id_Cliente,C.ID_CLIENTE) As Id_Cliente, i.Id_Producto, Isnull(c.Id_Contrato,0) As Id_Contrato, count(*) As Cantidad
 	            Into Z_CONTRATOS_FACTURADOS
				FROM Cbtes_Items i, Cbtes c , Cbtes_Tipos T, Contratos O
						WHERE c.id_trans = i.id_trans 
                                 AND T.Id_Tipo_Cbte = C.Id_Tipo_Cbte
								 AND C.Id_Contrato = O.Id_Contrato
                                 AND ((c.Comprobante_Nro = 0 AND c.Id_Estado_Cbte = 3) 
							      or  (c.Id_Estado_Cbte <> 0 and c.Id_Estado_Cbte <> 3))
                                 AND (T.Compromete_Factura = 1
 								 OR T.Compromete_Remitos = 1)
                                 AND DATEPART(yy,i.Fecha_QA) = DATEPART(yy,@pFecha_QA) 
                                 AND DATEPART(mm,i.Fecha_QA) = DATEPART(mm,@pFecha_QA) 
								 AND O.Id_Tipo_Con = @pId_Tipo_Cont
								 group by ISNULL(I.Id_Cliente,C.ID_CLIENTE) , i.Id_Producto	, c.Id_Contrato 


        CREATE NONCLUSTERED INDEX [IX_CONT_FACT_Cli]
                ON [dbo].Z_CONTRATOS_FACTURADOS (Id_Cliente,Id_producto)
                 
        CREATE NONCLUSTERED INDEX [IX_CONT_FACT_Cont]
                ON [dbo].Z_CONTRATOS_FACTURADOS (Id_Contrato) 

		IF OBJECT_ID (N'Z_Productos_Facturados', N'U') IS NOT NULL 
		BEGIN
			DROP TABLE Z_Productos_Facturados
		END

		SELECT L.Id_Cliente, I.Id_Producto
				INTO Z_Productos_Facturados
				FROM
				Clientes L, Cbtes_Items I, Cbtes C, Cbtes_Tipos CT
				WHERE L.Id_Cliente = I.Id_Cliente
				AND I.Id_Trans = C.Id_Trans 
				AND C.Id_Tipo_Cbte = CT.Id_Tipo_Cbte
				AND C.Id_Estado_Cbte NOT IN (0,3)
				AND CT.Compromete_Factura = 1
				AND DATEPART(yy,I.Fecha_QA) = DATEPART(yy,@pFecha_QA) 
                AND DATEPART(mm,I.Fecha_QA) = DATEPART(mm,@pFecha_QA) 
				GROUP BY L.Id_Cliente, I.Id_Producto

		 CREATE NONCLUSTERED INDEX [IX_FACT_Prod_Cli]
                ON Z_Productos_Facturados (Id_Cliente,Id_producto)

		INSERT INTO #CONTRATOS_PROCESAR
		   EXEC(@sql)

		DECLARE Cur_Facturar_Contratos CURSOR FOR
				   SELECT Id_Contrato,Id_Tiempo FROM #CONTRATOS_PROCESAR 

		OPEN Cur_Facturar_Contratos 
		FETCH NEXT FROM Cur_Facturar_Contratos INTO @Id_Contrato,@Id_Tiempo
		WHILE @@FETCH_STATUS=0
		BEGIN

			SET @pJson =	'{' +
							dbo.CF_Json_ParsearVariable('FlagUsarTrans', @pFlagUsarTrans, 'TINYINT') + ',' +
							dbo.CF_Json_ParsearVariable('ModoDebug', @pModoDebug, 'TINYINT') + ',' +
							dbo.CF_Json_ParsearVariable('Omitir_Resultado_OK', 1, 'TINYINT') + ',' +		
							dbo.CF_Json_ParsearVariable('Refacturar', @pRefacturar, 'TINYINT') + ',' +
							dbo.CF_Json_ParsearVariable('Incl_Cbtes_Cero', @pIncl_Cbtes_Cero, 'TINYINT') + ',' +
						    dbo.CF_Json_ParsearVariable('Id_Tiempo', @Id_Tiempo, 'CHAR(3)') + ',' +
							dbo.CF_Json_ParsearVariable('Id_Contrato', @Id_Contrato, 'INT') + ',' +
							dbo.CF_Json_ParsearVariable('Id_Usuario', @pId_Usuario, 'SMALLINT') + ',' +
							dbo.CF_Json_ParsearVariable('Fecha', @pFecha, 'DATETIME') + ',' +
							dbo.CF_Json_ParsearVariable('Lote', @pLote, 'VARCHAR(20)') + ',' +
							dbo.CF_Json_ParsearVariable('Flag_Tabla_Temp', 1, 'SMALLINT') + ',' +
							dbo.CF_Json_ParsearVariable('Fecha_QA', @pFecha_QA, 'DATETIME') + ',' +
							dbo.CF_Json_ParsearVariable('Fecha_Venc', @pFecha_Venc, 'DATETIME') + ',' +
				   			dbo.CF_Json_ParsearVariable('Fecha_Rem_Desde', @pFecha_Rem_Desde, 'DATETIME') + ',' +
						    dbo.CF_Json_ParsearVariable('Fecha_Rem_Hasta', @pFecha_Rem_Hasta, 'DATETIME') +
							'}'

				
			    EXEC @UltError = CPJ_Contrato_Facturar @pJson

				SET @Mensaje = 'Error when calling CPJ_Contrato_Facturar ' + @pJson
	            IF @UltError <> 0 RAISERROR (@Mensaje, 16,  1 ) 

 			    FETCH NEXT FROM Cur_Facturar_Contratos INTO @Id_Contrato,@Id_Tiempo
				IF @pModoDebug <> 0 
				   BEGIN
						PRINT '@@FETCH_STATUS: ' + CONVERT(VARCHAR(20),@@FETCH_STATUS)
						PRINT '@Id_Contrato: ' + CONVERT(VARCHAR(20),@Id_Contrato)
						PRINT '@UltError: ' + CONVERT(VARCHAR(20),@UltError)
						PRINT 'CPJ_Contrato_Facturar ' + CONVERT(VARCHAR(4000), @pJson )
				   END
		END
		CLOSE Cur_Facturar_Contratos
		DEALLOCATE Cur_Facturar_Contratos

		DROP TABLE #CONTRATOS_PROCESAR

	 	DROP TABLE Z_CONTRATOS_FACTURADOS
	 	DROP TABLE Z_Productos_Facturados

		UPDATE Cbtes_Lotes SET	Cantidad = (SELECT COUNT(*) FROM Cbtes WHERE Lote = @pLote) ,
								Importe =  (SELECT SUM(Imp_Total) FROM Cbtes WHERE Lote = @pLote),
								Fecha_Finalizacion = GETDATE(),
								Flag_enProceso = 0
				WHERE Lote = @pLote
				
		SET @pJson =	'{' +
							dbo.CF_Json_ParsearVariable('Id_Tipo_Lote', 1, 'INT') +  
							'}'
							
		EXEC @UltError = CPJU_Tri_Prender @pJson

		SET @Mensaje = 'Error when calling CPJU_Tri_Prender ' + @pJson
		IF @UltError <> 0 RAISERROR (@Mensaje, 16,  1 ) 					

		SET @Segundos = (SELECT DATEDIFF(s,Fecha_Inicio,Fecha_Finalizacion) FROM CBTES_LOTES WHERE LOTE = @pLote) 
		SET @Mensaje = 'Minutos Transcurridos: ' + CONVERT(VARCHAR(10),(@Segundos / 60 )  ) + ' ( ' + CONVERT(VARCHAR(10),(@Segundos)) +' segundos).'
 
		SELECT	 0				AS ErrorNumber 
				,0				AS ErrorSeverity  
				,0				AS ErrorState 
				,0				AS ErrorProcedure  
				,0				AS ErrorLine		
				,@Mensaje		AS ErrorMessage

END TRY  


BEGIN CATCH  
    IF EXISTS(SELECT * FROM @RESPUESTA)
	   SELECT * FROM @RESPUESTA
	    
    EXECUTE usp_GetErrorInfo
	
	UPDATE Cbtes_Lotes SET	Cantidad = (SELECT COUNT(*) FROM Cbtes WHERE Lote = @pLote) ,
							Importe =  (SELECT SUM(Imp_Total) FROM Cbtes WHERE Lote = @pLote),
							Fecha_Finalizacion = GETDATE(),
							Flag_enProceso = 0
			WHERE Lote = @pLote

			IF (SELECT CURSOR_STATUS('global','Cur_Facturar_Contratos') ) = -1
			   DEALLOCATE curContratoGenerarCbtes_ItemsXRemitosPropiosTr		 

			IF (SELECT CURSOR_STATUS('global','Cur_Facturar_Contratos') ) = 1
			BEGIN
			   CLOSE Cur_Facturar_Contratos
			   DEALLOCATE Cur_Facturar_Contratos		 
			END


	RETURN 9999
END CATCH

RETURN 0



/*

 

DECLARE @Param VARCHAR(5000)
SET @Param = '{' +
			'"Lote":"2022-ABR-GENERAL",' +
			'"Fecha":"20220401",' +
			'"Descripcion":"2022-ABRIL-GENERAL",' +
			'"Id_Lote_Tipo":"1",' + 
			'"Fecha_Desde":"20220401",' +
			'"Fecha_Hasta":"20220430"' +
			'"Fecha_QA":"20220401",' +
			'"Fecha_Venc":"20220430"' +
			'"Fecha_Rem_Desde":"20220401",' +
			'"Fecha_Rem_Hasta":"20220430",' +
			'"Id_Tipo_Cont":"1",' +
			'"Id_Usuario":"-1",' +
			'"FiltrarTarjeta":"0",' +
			'"FiltrarCliente":"0",' +
			'"FiltrarCondPago":"0",' +
			'"FiltrarTipoCbte":"0",' +
			'"FiltrarCantCont":"0",' +
			'"Refacturar":"0",' +
			'"Incl_Cbtes_Cero":"0",' +
			'"FlagUsarTrans":"0",' +
			'"ModoDebug":"0"' +
			'}'

EXEC CPJ_Cbtes_Lotes_Facturar @Param





*/
